


/******************************************************************************************************
 *                                                                                                    *
 *                        Example_2. ET-REMOTE MP3 Trig-Mode By Check EOF Signal                      *
 *                                                                                                    *
 ******************************************************************************************************
 *                                                                                                    *
 * Target MCU     : ATMEL AVR-MEGA128 (ET-BASE AVR atmega128 r3)                                      *
 *                : X-TAL : 16 MHz                                                                    *  
 *                                                                                                    *
 * Editor         : AVR Studio 4.15 Build 623                                                         *
 * Compiler       : WinAVR-20081205                                                                   *
 *                                                                                                    *
 * Port Interface :                                                                                   *
 *                                                                                                    *
 *            I/O : # MCU-MEGA128 #           # ET-MINI 3TO5TTL #                  # ET-REMOTE MP3 #  *
 *                  --------------          -------------------------              -----------------  *
 *                                                                                                    *                                   
 *                  PA0..PA7(OUT)  connect  IN0-IN7(#1)<--> OUT0-OUT7(#1)  connect     Trig CH1-CH8   *                                       
 *                  PC0..PC7(OUT)  connect  IN0-IN7(#2)<--> OUT0-OUT7(#2)  connect     Trig CH9-CH16  * 
 *                  PB0             ----------------------------------     connect     EOF Teminal    *   
 *                  +5V            connect  +VIN (#1'#2)<--> +VOUT         connect     +3.3V          *
 *                  GND            connect  GND  (#1,#2)<--> GND           connect     GND            *                                                                 
 *                                                                                                    *
 *                                                                                                    *
 *                                                                                 -DIP SW.MODE       *
 *          5V                                                                      S1=OFF,S2=OFF     *
 *         --+--                                            +------------------+   -DIF SW.CONFIG     *
 *           |                                              |                  |    S1=OFF,S2=ON      *
 *           +----------+                                   |          --------+-----------           *
 *           |          |      -----------------------      |         |     +VOUT3V3       |          *
 *     ------+-----     +-----|+VIN              +VOUT|-----+    Trig |                    |          *
 *    |        PA0 |----|-----|IN0                OUT0|-----|---------|CH1                 |          *
 *    |         .  |    |     | .                  .  |     |         | .                  |          *
 *    |         .  |    |     | .   ET-MINI3TO5#1  .  |     |         | .                  |          *
 *    |         .  |    |     | .                  .  |     |         | .                  |          *
 *    |        PA7 |----|-----|IN7                OUT7|-----|---------|CH8                 |          *
 *    |            |    |  +--|G                    G |--+  |         |                    |          *
 *    |            |    |  |  +-----------------------+  |  |         |   ET-REMOTE MP3V2  |          *
 *    |            |    +--|--|+VIN              +VOUT|--|--+    Trig |                    |          *
 *    |        PC0 |-------|--|IN0                OUT0|--|------------|CH9                 |          *
 *    |         .  |       |  | .                  .  |  |            | .                  |          *
 *    |         .  |       |  | .   ET-MINI3TO5#2  .  |  |            | .               EOF|---+      *
 *    |         .  |       |  | .                  .  |  |            | .                  |   |      *
 * +--|PB0     PC7 |-------|--|IN7                OUT7|--|------------|CH16   [Supply]     |   |      *
 * |   -----+------        +--|G                    G |--+            |       G    5V      |   |      *
 * |        |  Mega 128    |   -----------------------   |             -------+-----+------    |      *
 * |      --+--            |                             |                    |     |          |      *
 * |       ---             +-----------------------------+--------------------+     |          |      *
 * |        -              |                                                  |     +-->5V     |      *
 * |                     --+--                                              --+--              |      *
 * |                      ---                                                ---               |      *
 * |                       -                                                  -                |      *
 * |                                                                                           |      *
 * +-------------------------------------------------------------------------------------------+      *
 *                                                                                                    *
 *                                                                                                    *
 * Last Update     : 22/May/2012                                                                      *   
 * Create By       : Mr. Sittiphol Yooyod (WWW.ETT.CO.TH)                                             *
 *                                                                                                    * 
 ******************************************************************************************************/



#include <stdio.h>
#include <avr/io.h>                  //define port
#include <compat/deprecated.h>       //call function sbi(port,bit),cbi(port,bit) = Set,Clear bit
#include <avr/interrupt.h>


#define F_CPU 16000000UL             //CPU Clock Frequency (Hz)
#include <util/delay.h>              //call function delay



/*****************************************
 **         Function Delay ms           **
 *****************************************/

 void delay_ms(unsigned int cnt)
  {
    for(;cnt>0;cnt--)
       _delay_ms(1);
  }



/*****************************************
 **        Function Initial Port        **
 *****************************************/

 void Init_Port(void)
  {

   DDRA  = 0xFF     ;        //Set PA(0..7) = Output for Trig CH1-8  
   DDRB  = 0xFE     ;        //Set PB0      = Input  for Read EOF    
   DDRC  = 0xFF     ;        //Set PC(0..7) = Output for Trig CH9-16  
    

 //--- Set default output Port = 1  ----

   PORTA = 0xFF     ;   
   PORTB = 0xFF     ;        //Full Up PB0               
   PORTC = 0xFF     ;

   

  }



//---------------- Check Status Signal EOF : End OF File ---------------- 

void Chk_Eof()
{
  char eof                 ;
       
  do                            //Loop Check Eof = 0 :end file 
   {
     eof  = PINB              ; //Read PB0 : 0 = end of message , 1 = Ready for Play or Playing  
     eof  = eof & 0x01        ; //Mark bit 0
   }while(eof == 1)           ; //eof = 0 exit loop
  
   
  do                            //Loop Check Eof = 1 : Ready 
   {
     eof  = PINB              ; //Read PB0 : 0 = end of message , 1 = Ready for Play or Playing  
     eof  = eof & 0x01        ; //Mark bit 0
   }while(eof == 0)           ; //eof = 1 exit loop
  


}



 /****************************************************
  **                                                **
  **     Function Play File CH1-CH16(Trig'0')       **
  **                                                **
  ****************************************************/ 


void Play_File(void)
{
  
  char bt ;
    //--------------- PORTA[0..7] TRIG CH[1..8]-------------

  for(bt=0;bt<8;bt++)        //Loop Control Port bit for Trig Next File
   {
                      
    cbi(PORTA,bt)    ;    //PortA_Bit(x)=0 : Trig-CH(x+1)   

    delay_ms(20)     ;    //Delay 20 ms for Trig 0

    sbi(PORTA,bt)    ;    //PortA_Bit(x)=1  

     Chk_Eof()        ;    //Check Play End File
         
   }

    //--------------- PORTC[0..7] TRIG CH[9..16]-------------

  for(bt=0;bt<8;bt++)        //Loop Control Port bit for Trig Next File
   {
                      
     cbi(PORTC,bt)    ;    //PortC_Bit(x)=0 : Trig-CH(x+9)   

     delay_ms(20)     ;    //Delay 20 ms for Trig 0

     sbi(PORTC,bt)    ;    //PortC_Bit(x)=1  

     Chk_Eof()        ;    //Check Play End File
         
    }

}






/**********************************************************************
 **                                                                  **
 **                         main Program                             **
 **                                                                  **
 **********************************************************************/
 
 int main(void) 
 {

    Init_Port()       ;
    delay_ms(3000)    ;  //delay 3 sec for Synce Board MP3 Ready
    
   while(1)
   {
    delay_ms(3000)  ;
    Play_File()     ;   //Sen Signal Trig Start Play File CH1

   }   
 
}
